// XISLAssignTag.cpp: CXISLAssignTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLAssignTag.h"
#include "XISLVar.h"
#include "XISLExcItem.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLAssignTag::CXISLAssignTag()
{
	m_nTagType = ID_TAG_ASSIGN;
	m_nBmpID = IDB_ASSIGN;

	m_pParentTag = NULL;
	m_pVar=NULL;
}

CXISLAssignTag::~CXISLAssignTag()
{

}

CXISLAssignTag::CXISLAssignTag(const CXISLAssignTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;
}

CXISLAssignTag& CXISLAssignTag::operator=(const CXISLAssignTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;
	}
	return *this;
}

BOOL CXISLAssignTag::SetAttribute(CXISLVar *pVar,LPCTSTR lpszExpr)
{
	m_pVar = pVar;
	m_strExpr = lpszExpr;
	return TRUE;
}

BOOL CXISLAssignTag::SetAttribute(LPCTSTR lpszName,LPCTSTR lpszExpr)
{
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	CXISLVar *pVar = pExcItem->m_pLocalVar->FindVarWithParent(lpszName);
	if(pVar == NULL)
	{
		pVar = new CXISLVar;
		if(pVar->SetAttribute(lpszName,lpszExpr,FALSE,FALSE) != 0)
		{
			delete pVar;
			return FALSE;
		}
		if(pExcItem->m_pLocalVar->RegistVar(pVar) != 0)
		{
			delete pVar;
			return FALSE;
		}
	}

	m_pVar = pVar;
	m_pVar->ReferCount(TRUE);
	m_strExpr = lpszExpr;
	return TRUE;
}

LPCTSTR CXISLAssignTag::GetXISLString()
{
	CString strName;
	m_pVar->GetVarNameEx(strName);
	m_strXISL = "<assign name = \"";
	m_strXISL += strName;
	m_strXISL += "\" expr =\"";
	m_strXISL += m_strExpr;
	m_strXISL += "\"/>\r\n";

	return m_strXISL;
}

//BOOL CXISLAssignTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLAssignTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_ASSIGN];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

LPCTSTR CXISLAssignTag::GetName()
{
	if(m_pVar)
		return m_pVar->GetVarName();
	else
		return "";
}
